(function () {
  if (!/aliexpress\.com/.test(location.hostname)) return;

  function parsePrice(text) {
    if (!text) return 0;
    const cleaned = text.replace(/[^\d,\.]/g, ""); // garder chiffres , .
    if (!cleaned) return 0;
    return parseFloat(cleaned.replace(",", ".")) || 0;
  }

  function extractCart() {
    try {
      const items = [];
      let totalUSD = 0;
      let shippingUSD = 0;

      // ✅ Cibler "Total estimé" et "Expédition"
      const summaryBlocks = document.querySelectorAll(
        ".cart-summary-item-wrapStyle",
      );
      summaryBlocks.forEach((block) => {
        const label = block.querySelector(".cart-summary-item-wrapStyle-label");
        const valEl = block.querySelector(
          ".cart-summary-item-wrapStyle-content span",
        );
        if (!label || !valEl) return;

        const labelTxt = label.innerText.trim().toLowerCase();
        const valTxt = valEl.textContent || valEl.innerText;

        if (labelTxt.includes("total estimé")) {
          totalUSD = parsePrice(valTxt);
        }
        if (labelTxt.includes("expédition")) {
          shippingUSD = parsePrice(valTxt);
        }
      });

      // ✅ Produits
      const nodes = document.querySelectorAll(
        ".cart-product, .cart-product-item, .product-item",
      );
      nodes.forEach((el, idx) => {
        const bg = el.querySelector(
          ".cart-product-img, .cart-summary-chosenCartLines-item-img, .product-image",
        );
        let image = "";
        if (bg && bg.style && bg.style.backgroundImage) {
          image = bg.style.backgroundImage
            .replace(/^url\(["']?/, "")
            .replace(/["']?\)$/, "");
        } else {
          const img = el.querySelector("img");
          image = img ? img.src : "";
        }

        const titleEl = el.querySelector(
          ".cart-product-name-title, .product-title, .title",
        );
        const title = titleEl
          ? titleEl.innerText.trim()
          : "Produit AliExpress " + idx;

        const priceText =
          (
            el.querySelector(
              ".cart-product-price-buynow .es--wrap--1Hlfkoj, .price, .current-price",
            ) || {}
          ).innerText || "";
        const price = parsePrice(priceText);

        const qInput = el.querySelector(
          '.comet-v2-input-number-input, input[type="number"]',
        );
        const qty = qInput
          ? parseInt(qInput.value.replace(/[^0-9]/g, "")) || 1
          : 1;

        const linkEl = el.querySelector('a[href*="/item/"]');
        let url = "";
        if (linkEl && linkEl.href) {
          url = linkEl.href;
        } else if (titleEl) {
          const titleLink = titleEl.closest("a");
          if (titleLink && titleLink.href) {
            url = titleLink.href;
          }
        }

        items.push({
          id: "ali_" + idx + "_" + btoa(title).substr(0, 8),
          title: title,
          image: image,
          price: price.toFixed(2),
          quantity: qty,
          url: url,
          source: "aliexpress",
        });
      });

      // ✅ Envoi dans storage
      if (items.length > 0) {
        const payload = {
          produits: items,
          total:
            totalUSD > 0
              ? totalUSD.toFixed(2)
              : items
                  .reduce(
                    (s, i) => s + parseFloat(i.price || 0) * (i.quantity || 1),
                    0,
                  )
                  .toFixed(2),
          shipping: shippingUSD > 0 ? shippingUSD.toFixed(2) : "0.00",
        };
        chrome.storage.local.set({ ayoplus_cart: payload });
        console.log("✅ AyoPlus cart stored", payload);
      }
    } catch (err) {
      console.error("❌ AyoPlus parse error", err);
    }
  }

  const obs = new MutationObserver(() => extractCart());
  obs.observe(document.documentElement || document.body, {
    childList: true,
    subtree: true,
  });

  // initial run
  setTimeout(extractCart, 800);
})();
