const cartEl = document.getElementById("cart");
const totalEl = document.getElementById("total");
const shippingEl = document.getElementById("shipping");
const sendBtn = document.getElementById("send");
const statusEl = document.getElementById("status");

function renderCart(panier) {
  cartEl.innerHTML = "";

  console.log("panier", panier);
  if (!panier || !panier.produits || panier.produits.length === 0) {
    cartEl.innerHTML = "<em>Panier vide ou non détecté.</em>";
    sendBtn.disabled = true;
    totalEl.textContent = "";
    shippingEl.textContent = "";
    statusEl.textContent = "⚠️ Aucun panier trouvé";
    return;
  }

  panier.produits.forEach((it) => {
    const d = document.createElement("div");
    d.className = "item";
    d.innerHTML = `
      <img src="${it.image || ""}" />
      <div>
        <div style="font-weight:600">${it.title}</div>
        <div class="muted">USD $${parseFloat(it.price).toFixed(2)} × ${
      it.quantity
    }</div>
      </div>`;
    cartEl.appendChild(d);
  });

  if (panier.shipping && parseFloat(panier.shipping) > 0) {
    shippingEl.textContent = `Expédition AliExpress : $${parseFloat(
      panier.shipping,
    ).toFixed(2)}`;
  } else {
    shippingEl.textContent = "";
  }

  const totalVal = parseFloat(panier.total || 0);
  totalEl.textContent = `Total estimé (AliExpress) : $${totalVal.toFixed(2)}`;

  sendBtn.disabled = false;
  statusEl.textContent = "✅ Panier détecté";
}

chrome.storage.local.get("ayoplus_cart", (res) => {
  renderCart(res.ayoplus_cart || null);
});

// ✅ Envoi vers WP (REST → fallback AJAX)
sendBtn.addEventListener("click", async () => {
  chrome.storage.local.get("ayoplus_cart", async (res) => {
    const panier = res.ayoplus_cart;
    if (!panier) {
      alert("Aucun panier détecté");
      return;
    }

    chrome.storage.sync.get(["wpurl"], async (v) => {
      const base = (v.wpurl || 'https://ayoplus.biz').replace(/\/+$/, '');
      const restUrl = base + '/wp-json/ayoplus/v1/import-cart';
      const ajaxUrl = base + '/wp-admin/admin-ajax.php?action=ayoplus_import';

      statusEl.textContent = "⏳ Envoi en cours...";

      try {
        // --- REST ---
        let r = await fetch(restUrl, {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify(panier),
        });
        let j = await r.json();

        if (j && j.status === "success" && j.redirect) {
          statusEl.textContent = "✅ Import via REST";
          window.open(j.redirect, "_blank");
          return;
        }

        // --- Fallback AJAX ---
        console.warn("⚠️ REST échoué, tentative AJAX…", j);

        r = await fetch(ajaxUrl, {
          method: "POST",
          headers: {
            "Content-Type": "application/x-www-form-urlencoded;charset=UTF-8",
          },
          body: new URLSearchParams({ data: JSON.stringify(panier) }),
        });
        j = await r.json();

        if (j && j.success && j.data && j.data.redirect) {
          statusEl.textContent = "✅ Import via AJAX";
          window.open(j.data.redirect, "_blank");
          return;
        }

        statusEl.textContent = "❌ Erreur API";
        alert("Erreur API: " + JSON.stringify(j || {}));
      } catch (err) {
        console.error("❌ Erreur API:", err);
        statusEl.textContent = "❌ Erreur réseau";
        alert("Erreur réseau: " + err.message);
      }
    });
  });
});
